#include <stdio.h>
#include <stdlib.h>
//#include <GL/glew.h>
#ifdef _WIN32
#include <GL/wglew.h>
#endif 
#if defined(__APPLE__) || defined(__MACOSX)
#include <GLUT/glut.h>
#else
#include <GL/freeglut.h>
#endif


#include <cuda.h> 
#include <cuda_runtime_api.h>
#include <cuda_gl_interop.h>

// CUDA runtime
// CUDA utilities and system includes
#include <cuda_runtime.h>
#include <cuda_gl_interop.h>

//#include <helper_functions.h>
#include <helper_cuda.h>
#include <helper_gl.h>
//#include <rendercheck_gl.h>


#include <math.h>
#include <string.h>
#include <png.h> 
//#include <cstdio>

#define MAX_EPSILON 50
#define REFRESH_DELAY	  5 //ms


//#define MAX(a,b) ((a > b) ? a : b)
#define BUFFER_DATA(i) ((char *)0 + i)

static const char *shader_code = 
"!!ARBfp1.0\n"
"TEX result.color, fragment.texcoord, texture[0], 2D; \n"
"END";

GLuint gl_PBO, gl_Tex, gl_Shader;
struct cudaGraphicsResource *cuda_pbo_resource; // handles OpenGL-CUDA exchange

//Source image on the host side
uchar4 *h_Src = 0;

// Destination image on the GPU side
uchar4 *d_dst = NULL;

unsigned short h_ruletable;

extern char p_board_width;
extern char p_board_height;

int button_down = 0;
int version = 0;
int numSMs = 0;
int imageW = 1024, imageH = 1024;
unsigned int hTimer;
int h_offsetx = 0;
int h_offsety = 0;
int zoom = 0;
int is_fav[1 << 11];
bool ruletable_visible = false; 
bool run_cell_auto = true;
//int run_cell_auto_steps = 1;
int cell_auto_speed = 0;

void initOpenGLBuffers(int w, int h);
void renderImage(bool bUseOpenGL);

extern "C" void random_colors(int seed);
extern "C" void init_cellauto(int seed);
extern "C" void run_cellauto(int numSMs);
extern "C" void display_cellauto(uchar4 *dst,int imageW, int imageH,int numSMs);
//extern "C" void paint_cell(int x,int y,int c);
//extern "C" void saveF(char *filename);
//extern "C" void saveImg(char *filename);
//extern "C" bool openF(char *filename);
extern "C" bool create_board23();
extern "C" int get_red(int i);
extern "C" int get_green(int i);
extern "C" int get_blue(int i);
extern "C" void init_color_palette();

GLuint compileASMShader(GLenum program_type, const char *code) {
    GLuint program_id;
    glGenProgramsARB(1, &program_id);
    glBindProgramARB(program_type, program_id);
    glProgramStringARB(program_type, GL_PROGRAM_FORMAT_ASCII_ARB, (GLsizei) strlen(code), (GLubyte *) code);

    GLint error_pos;
    glGetIntegerv(GL_PROGRAM_ERROR_POSITION_ARB, &error_pos);
    if (error_pos != -1) {
        const GLubyte *error_string;
        error_string = glGetString(GL_PROGRAM_ERROR_STRING_ARB);
        fprintf(stderr, "Program error at position: %d\n%s\n", (int)error_pos, error_string);
        return 0;
    }
    return program_id;
}
void reshapeFunc(int w, int h) {
    glViewport(0, 0, w, h);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);

    initOpenGLBuffers(w, h);
    imageW = w;
    imageH = h;
}
void renderImage(bool bUseOpenGL) {
  //printf("renderImage\n");
  if (bUseOpenGL) {
    checkCudaErrors(cudaGraphicsMapResources(1, &cuda_pbo_resource, 0));
    size_t num_bytes;
    checkCudaErrors(cudaGraphicsResourceGetMappedPointer((void**)&d_dst, &num_bytes, cuda_pbo_resource));
  }
  //printf("map\n");
  display_cellauto(d_dst,imageW,imageH,numSMs);
  //cutilDeviceSynchronize();
  //printf("display\n");
  if (bUseOpenGL) {
    checkCudaErrors(cudaGraphicsUnmapResources(1, &cuda_pbo_resource, 0));
  }  
  //printf("unmap\n");
}
void displayCA() {
    //cutilCheckError(cutResetTimer(hTimer));  
    glEnable(GL_TEXTURE_2D);
    renderImage(true);
    glBindTexture(GL_TEXTURE_2D, gl_Tex);
    glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, imageW, imageH, GL_RGBA, GL_UNSIGNED_BYTE, BUFFER_DATA(0));
    glBindProgramARB(GL_FRAGMENT_PROGRAM_ARB, gl_Shader);
    glEnable(GL_FRAGMENT_PROGRAM_ARB);
    glDisable(GL_DEPTH_TEST);

    glBegin(GL_QUADS);
    glTexCoord2f(0.0f, 0.0f); glVertex2f(0.0f, 0.0f);
    glTexCoord2f(1.0f, 0.0f); glVertex2f(1.0f, 0.0f);
    glTexCoord2f(1.0f, 1.0f); glVertex2f(1.0f, 1.0f);
    glTexCoord2f(0.0f, 1.0f); glVertex2f(0.0f, 1.0f);
    glEnd();

    glBindTexture(GL_TEXTURE_2D, 0);
    glDisable(GL_FRAGMENT_PROGRAM_ARB);
    glutSwapBuffers();
}
void displayFunc(void) {
  //if (ruletable_visible == true) {
  //  displayRT();
  //} else {
    displayCA();
  //}
}
void initOpenGLBuffers(int w, int h)
{
    // delete old buffers
    if (h_Src) {
        free(h_Src);
        h_Src = 0;
    }

    if (gl_Tex) {
        glDeleteTextures(1, &gl_Tex);
        gl_Tex = 0;
    }
    if (gl_PBO) {
		//DEPRECATED: cutilSafeCall(cudaGLUnregisterBufferObject(gl_PBO));    
		cudaGraphicsUnregisterResource(cuda_pbo_resource);
        glDeleteBuffers(1, &gl_PBO);
        gl_PBO = 0;
    }

    // check for minimized window
    if ((w==0) && (h==0)) {
        return;
    }

    // allocate new buffers
	h_Src = (uchar4*)malloc(w * h * 4);

    //printf("Creating GL texture...\n");
        glEnable(GL_TEXTURE_2D);
        glGenTextures(1, &gl_Tex);
        glBindTexture(GL_TEXTURE_2D, gl_Tex);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, h_Src);
    //printf("Texture created.\n");

    //printf("Creating PBO...\n");
        glGenBuffers(1, &gl_PBO);
        glBindBuffer(GL_PIXEL_UNPACK_BUFFER_ARB, gl_PBO);
        glBufferData(GL_PIXEL_UNPACK_BUFFER_ARB, w * h * 4, h_Src, GL_STREAM_COPY);
        //While a PBO is registered to CUDA, it can't be used 
        //as the destination for OpenGL drawing calls.
        //But in our particular case OpenGL is only used 
        //to display the content of the PBO, specified by CUDA kernels,
        //so we need to register/unregister it only once.
        
	// DEPRECATED: cutilSafeCall( cudaGLRegisterBufferObject(gl_PBO) );
    checkCudaErrors(cudaGraphicsGLRegisterBuffer(&cuda_pbo_resource, gl_PBO, cudaGraphicsMapFlagsWriteDiscard));
    //printf("PBO created.\n");

    // load shader program
    gl_Shader = compileASMShader(GL_FRAGMENT_PROGRAM_ARB, shader_code);
}
void cleanup() {
    if (h_Src) {
        free(h_Src);
        h_Src = 0;
    }
	cudaGraphicsUnregisterResource(cuda_pbo_resource);
        glBindBuffer(GL_PIXEL_UNPACK_BUFFER_ARB, 0);

	    glDeleteBuffers(1, &gl_PBO);
        glDeleteTextures(1, &gl_Tex);
        glDeleteProgramsARB(1, &gl_Shader);
}

void initGL(int *argc, char **argv)
{
    printf("Initializing GLUT...\n");
        glutInit(argc, argv);
        glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE);
        glutInitWindowSize(imageW, imageH);
        glutInitWindowPosition(0, 0);
        glutCreateWindow(argv[0]);

        //printf("Loading extensions: %s\n", glewGetErrorString(glewInit()));
	//    if (!glewIsSupported( "GL_VERSION_1_5 GL_ARB_vertex_buffer_object GL_ARB_pixel_buffer_object" )) {
		//    fprintf(stderr, "Error: failed to get minimal extensions for demo\n");
		//    fprintf(stderr, "This sample requires:\n");
		//    fprintf(stderr, "  OpenGL version 1.5\n");
		//    fprintf(stderr, "  GL_ARB_vertex_buffer_object\n");
		//    fprintf(stderr, "  GL_ARB_pixel_buffer_object\n");
		    //cutilExit(*argc, argv);
	//    }
	printf("OpenGL window created.\n");
}
void initData() {
    int dev = 0;
    cudaDeviceProp deviceProp;
    cudaGetDeviceProperties(&deviceProp, dev);
    version = deviceProp.major*10 + deviceProp.minor;
    printf("version: %d \n", version);
    numSMs = deviceProp.multiProcessorCount;
}
int generations_per_second;
//int time1;
int time23;
int generation_frames_remaining = 1;
void timerEvent(int value) {
  if ((run_cell_auto == true) & (ruletable_visible == false)) {
    if (cell_auto_speed >= 0) {
      int run_cell_auto_steps = 1 << cell_auto_speed;
      for (int i = 0;i < run_cell_auto_steps;i++) {
        run_cellauto(numSMs);
        //num_generations = num_generations + 1;
        generations_per_second++;
        if (time(NULL) != time23) {
          //printf("gps %d \n",generations_per_second);
          generations_per_second = 0;
          time23 = time(NULL);
        }
      }
    } else {
      generation_frames_remaining = generation_frames_remaining - 1;
      if (generation_frames_remaining == 0) {
        generation_frames_remaining = 1 << -cell_auto_speed;
        run_cellauto(numSMs);
        //num_generations = num_generations + 1;
      }
    }
    glutPostRedisplay();
  }
  glutTimerFunc(REFRESH_DELAY, timerEvent, 1);

}
const char *hex_char = "0123456789ABCDEF";
void display_hex_code() {
  char hex_code[32];
  int r = h_ruletable;
  hex_code[4] = 0;
  for (int i = 3;i >= 0;i--) {
    hex_code[i] = hex_char[r & 15]; 
    r = r >> 4;
  }
  r = h_ruletable;
  if (((is_fav[r >> 5] >> (r & 31)) & 1) == 1) {
    strcpy(&hex_code[4]," Favorite");
    //hex_code[5] = 'F';    
  }
  printf("%s\n",hex_code);
  glutSetWindowTitle(hex_code);
}
//const char *rt_keyboard = "1qaz2wsx3edc4rfv";  
const char *rt_keyboard = "vfr4cde3xsw2zaq1";
void keyboardFunc(unsigned char key, int x, int y) {
    for (int i = 0;i < 16;i++) {
      if (key == rt_keyboard[i]) {
        h_ruletable = h_ruletable ^ (1 << i);
        display_hex_code();
        init_cellauto(time(0));
      }
    }
    if (key == ']') {
      if (cell_auto_speed < 30) {
        cell_auto_speed = cell_auto_speed + 1;
      }
    } 
    if (key == '[') {
      if (cell_auto_speed > -30) {
        cell_auto_speed = cell_auto_speed - 1;
      }
    } 

    if (key == ' ') {
        h_ruletable = h_ruletable ^ ((short) rand());
        //h_ruletable = (short) (h_ruletable * 3)+1; ;
        display_hex_code();
        init_cellauto(time(0));
      //run_cellauto(numSMs);
    }
    if (key == 13) {
      //run_cell_auto = !run_cell_auto;
      init_cellauto(time(0));
      random_colors(time(0));
    }

  glutPostRedisplay();

}
int hexadecimalToDecimal(char hexVal[]) 
{    
  int len = strlen(hexVal); 
  int base = 1; 
  int dec_val = 0; 
      
  for (int i=len-1; i>=0; i--) {    
    if (hexVal[i]>='0' && hexVal[i]<='9') { 
      dec_val += (hexVal[i] - 48)*base; 
      base = base * 16; 
    } else if (hexVal[i]>='A' && hexVal[i]<='F') { 
      dec_val += (hexVal[i] - 55)*base; 
      base = base * 16; 
    } else if (hexVal[i]>='a' && hexVal[i]<='f') {
      dec_val += (hexVal[i] - 87)*base; 
      base = base * 16; 
    }
       
  } 
      
  return dec_val; 
} 
void read_favorites_file() {
  char hexVal[32];
  FILE *f = fopen("favorites","r");
  while (fscanf(f,"%s",hexVal) == 1){    
    int r0 = hexadecimalToDecimal(hexVal);
    int r1 = 0;int r2 = 0;int r3 = 0;
    if (((is_fav[r0 >> 5] >> (r0 & 31)) & 1) == 1) {
      printf("%s \n", hexVal);
    }
    for (int i0 = 0;i0 < 16;i0++) {
      int i1 = ((i0 & 1) << 3) | ((i0 & 2) << 1) | ((i0 & 4) >> 1) | ((i0 & 8) >> 3);
      int b = (r0 >> i0) & 1;
      r1 = r1 | (b << i1);
      r2 = r2 | ((b^1) << (i0^15));
      r3 = r3 | ((b^1) << (i1^15));
    }
    is_fav[r0 >> 5] = is_fav[r0 >> 5] | (1 << (r0 & 31));
    is_fav[r1 >> 5] = is_fav[r1 >> 5] | (1 << (r1 & 31));
    is_fav[r2 >> 5] = is_fav[r2 >> 5] | (1 << (r2 & 31));
    is_fav[r3 >> 5] = is_fav[r3 >> 5] | (1 << (r3 & 31));
  }
}
void keyboardFunc2(int key, int x, int y) {
  int a = 6;
  if (key == 100) { //left
    h_offsetx = h_offsetx - (1 << a);
  }
  if (key == 102) { //right
    h_offsetx = h_offsetx + (1 << a);
  }
    glutPostRedisplay();  
}
int main(int argc, char **argv)
{
  initGL(&argc, argv);
  initData();
  //printf("%d \n",argc);
    if (create_board23() == false) {
      printf("error: out of memory\n");
      return -1;
    }
    //init_h_ruletable();
  init_cellauto(time(0));
  //printf("init_cellauto \n");
  random_colors(time(0));
  //printf("random_colors \n");
  h_ruletable = rand();//0x6E6E;
  if (argc > 1) {
    h_ruletable = hexadecimalToDecimal(argv[1]);
  }
  //h_ruletable = (short) rand();

  glutDisplayFunc(displayFunc);
  glutReshapeFunc(reshapeFunc);
  glutTimerFunc(REFRESH_DELAY, timerEvent, 0);
  glutKeyboardFunc(keyboardFunc);
  glutSpecialFunc(keyboardFunc2);
  //glutMouseFunc(mousedrawFunc);
  //glutMotionFunc(mouseMotionFunc);
  //glutSetWindowTitle("CA1D");
  read_favorites_file();
  display_hex_code();
  atexit(cleanup);
  glutMainLoop();
  exit(EXIT_SUCCESS);

}

